/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.panorama;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class ExternalTexturePanoramaRenderer
extends AbstractGui {
    private ExternalTextureResourceLocation overlay_texture;
    private float time;
    private String name = null;
    private String dir;
    private boolean prepared = false;
    private List<ExternalTextureResourceLocation> pano = new ArrayList<ExternalTextureResourceLocation>();
    private float speed = 1.0f;
    private double fov = 85.0;
    private float angle = 25.0f;

    public ExternalTexturePanoramaRenderer(String panoDir) {
        this.dir = panoDir;
        File props = new File(this.dir + "/properties.txt");
        if (props.exists()) {
            PropertiesSet s = PropertiesSerializer.getProperties((String)props.getPath());
            if (s != null) {
                List l = s.getPropertiesOfType("panorama-meta");
                if (l != null && !l.isEmpty()) {
                    String an;
                    String fo;
                    String sp;
                    this.name = ((PropertiesSection)l.get(0)).getEntryValue("name");
                    if (this.name == null) {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Missing 'name' value in properties file for panorama cube: " + this.dir);
                        System.out.println("###############################################");
                    }
                    if ((sp = ((PropertiesSection)l.get(0)).getEntryValue("speed")) != null && MathUtils.isFloat((String)sp)) {
                        this.speed = Float.parseFloat(sp);
                    }
                    if ((fo = ((PropertiesSection)l.get(0)).getEntryValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                        this.fov = Double.parseDouble(fo);
                    }
                    if ((an = ((PropertiesSection)l.get(0)).getEntryValue("angle")) != null && MathUtils.isFloat((String)an)) {
                        this.angle = Float.parseFloat(an);
                    }
                } else {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing 'panorama-meta' section in properties file for panorama cube: " + this.dir);
                    System.out.println("###############################################");
                }
            } else {
                System.out.println("############## ERROR [FANCYMENU] ##############");
                System.out.println("An error happened while trying to get properties for panorama cube: " + this.dir);
                System.out.println("###############################################");
            }
        } else {
            System.out.println("############## ERROR [FANCYMENU] ##############");
            System.out.println("Properties file not found for panorama cube: " + this.dir);
            System.out.println("###############################################");
        }
    }

    public void preparePanorama() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(this.dir + "/panorama")).exists() && imagesDir.isDirectory()) {
            for (int i = 0; i < 6; ++i) {
                File f = new File(this.dir + "/panorama/panorama_" + i + ".png");
                if (!f.exists() || !f.isFile()) {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing panorama image 'panorama_" + i + ".png' for panorama cube: " + this.name);
                    System.out.println("###############################################");
                    return;
                }
                ExternalTextureResourceLocation r = new ExternalTextureResourceLocation(f.getPath());
                this.pano.add(r);
            }
            File overlay = new File(this.dir + "/overlay.png");
            if (overlay.exists()) {
                this.overlay_texture = new ExternalTextureResourceLocation(overlay.getPath());
            }
            this.prepared = true;
        }
    }

    public void render() {
        try {
            this.renderRaw(1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void renderRaw(float panoramaAlpha) {
        if (this.prepared) {
            this.time += Minecraft.func_71410_x().func_184121_ak() * this.speed;
            float pitch = MathHelper.func_76126_a((float)(this.time * 0.001f)) * 5.0f + this.angle;
            float yaw = -this.time * 0.1f;
            Minecraft mc = Minecraft.func_71410_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.fov, (float)((float)mc.func_228018_at_().func_198109_k() / (float)mc.func_228018_at_().func_198091_l()), (float)0.05f, (float)10.0f));
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            for (int j = 0; j < 4; ++j) {
                RenderSystem.pushMatrix();
                float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
                float f1 = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
                RenderSystem.translatef((float)f, (float)f1, (float)0.0f);
                RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderSystem.rotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                for (int k = 0; k < 6; ++k) {
                    ExternalTextureResourceLocation r = this.pano.get(k);
                    if (r == null) continue;
                    if (!r.isReady()) {
                        r.loadTexture();
                    }
                    mc.func_110434_K().func_110577_a(r.getResourceLocation());
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    int l = Math.round(255.0f * panoramaAlpha) / (j + 1);
                    if (k == 0) {
                        bufferbuilder.func_225582_a_(-1.0, -1.0, 1.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, 1.0, 1.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, 1.0, 1.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, -1.0, 1.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 1) {
                        bufferbuilder.func_225582_a_(1.0, -1.0, 1.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, 1.0, 1.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, 1.0, -1.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, -1.0, -1.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 2) {
                        bufferbuilder.func_225582_a_(1.0, -1.0, -1.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, 1.0, -1.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, 1.0, -1.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, -1.0, -1.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 3) {
                        bufferbuilder.func_225582_a_(-1.0, -1.0, -1.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, 1.0, -1.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, 1.0, 1.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, -1.0, 1.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 4) {
                        bufferbuilder.func_225582_a_(-1.0, -1.0, -1.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, -1.0, 1.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, -1.0, 1.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, -1.0, -1.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 5) {
                        bufferbuilder.func_225582_a_(-1.0, 1.0, 1.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(-1.0, 1.0, -1.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, 1.0, -1.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_225582_a_(1.0, 1.0, 1.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, l).func_181675_d();
                    }
                    tessellator.func_78381_a();
                }
                RenderSystem.popMatrix();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            }
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            if (this.overlay_texture != null) {
                if (!this.overlay_texture.isReady()) {
                    this.overlay_texture.loadTexture();
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.overlay_texture.getResourceLocation());
                ExternalTexturePanoramaRenderer.func_238463_a_((MatrixStack)CurrentScreenHandler.getMatrixStack(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)Minecraft.func_71410_x().field_71462_r.field_230708_k_, (int)Minecraft.func_71410_x().field_71462_r.field_230709_l_, (int)Minecraft.func_71410_x().field_71462_r.field_230708_k_, (int)Minecraft.func_71410_x().field_71462_r.field_230709_l_);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

